SELECT
"public".hazard.hazard_localid,
poly.enumvalue,
point.enumvalue,
"public".geopoint.pointno,
"public".geopoint.pointlocal_id,
"public".geopoint.longitude,
"public".geopoint.latitude,
"public".geopoint.coordrefsys,
"public".geopoint.distance,
"public".geopoint.bearing,
"public".geopoint.frompoint_guid,
"public".geopoint.userinputformat,
"public".geopoint.coordformat,
"public".geopoint.user_entered_x,
"public".geopoint.user_entered_y
FROM
"public".hazard
INNER JOIN "public".hazard_has_geospatialinfo ON "public".hazard_has_geospatialinfo.hazard_guid = "public".hazard.hazard_guid
INNER JOIN "public".geospatialinfo ON "public".hazard_has_geospatialinfo.geospatialinfo_guid = "public".geospatialinfo.geospatialinfo_guid
INNER JOIN "public".imsmaenum AS poly ON poly.imsmaenum_guid = "public".geospatialinfo.shapeenum_guid
INNER JOIN "public".geopoint ON "public".geospatialinfo.geospatialinfo_guid = "public".geopoint.geospatialinfo_guid
INNER JOIN "public".imsmaenum AS point ON "public".geopoint.pointtypeenum_guid = point.imsmaenum_guid
WHERE
"public".hazard.hazard_localid = 'N-DA-KI-1004'
ORDER BY
"public".geopoint.pointno ASC
